#*******************************************************************************
#
# Programmer: Roth In
#
# Assignment: A.I. Final Project 
#
# Description: Using greedy approach to find a solution for 8-puzzle 
#
# Date: 12 / 3 / 2020
#*******************************************************************************

import math, json, sys
from random import randrange, randint
from time import sleep

arr = [-1,1, 2, 3, 0] # 2 by 2
arr = [-1,1,2,3,4,5,6,7,8, 0] ## ******** goal state ******** 
#arr = [-1,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15, 0]

# swap element in the arr
def swap(arr, i, j):
    temp = arr[i];
    arr[i] = arr[j]
    arr[j] = temp

# calculate the adjecent scores. 
def calculate_spot(i, j, by):
    value = 0
    if(i%by==0 and (j+1 == i or j-by == i or j+by == i)):
        value = 0.5
    elif(i%by==1 and (j-1 == i or j-by == i or j+by==i)):
        value = 0.5
    elif(j-by == i or j + by == i):
        value = 0.5

    return value

# check to validate and calculate matched 
def check(checkArr):
    matched = 0
    by = int(math.sqrt(len(arr)-1))
    for i, j in zip(arr, checkArr):
        if(i == j):
            matched+=1.0
        else:
            matched+= calculate_spot(i,j, by)
   
    return matched / len(arr) * 100

data = []
raw_data = []
# output arr in square format and save the state
def print_arr(arr_data, printing = False):
    global raw_data, data
    
    if(printing):
        by = int(math.sqrt(len(arr_data)-1))
        for i in range(1, len(arr_data)):
            if(arr_data[i] == 0):
                print(f"\033[47m \033[0m  ", end="")
            else:
                print(f"{arr_data[i]}  ", end="")
            if(i%by == 0):
                print()
        print()
    else:
        data.append(''.join(str(e) for e in arr_data))
        raw_data.append(arr_data[:])
        #input()

# find and return index for the best move 
def greedy(arr, zero_index, by, back, front): 
    rate = 0
    index = zero_index

    if(back  ):
        #go back
        temp = arr[:]
        swap(temp, zero_index, zero_index-1)
        new_rate = check(temp)
        if(new_rate > rate and ''.join(str(e) for e in temp) not in data):
            rate = new_rate
            index = zero_index-1
            
    if(front  ):
        #go front
        temp = arr[:]
        swap(temp, zero_index, zero_index+1)
        new_rate = check(temp)
        if(new_rate > rate and ''.join(str(e) for e in temp) not in data):
            rate = new_rate
            index = zero_index+1
            
    #if can go up then go up
    if(zero_index - by > 0  ):
        temp = arr[:]
        swap(temp, zero_index, zero_index-by)
        new_rate = check(temp)
        if(new_rate > rate and ''.join(str(e) for e in temp) not in data):
            rate = new_rate
            index = zero_index-by
            
    #if can go down, then go down
    if(zero_index + by < len(arr)  ):
        temp = arr[:]
        swap(temp, zero_index, zero_index+by)
        new_rate = check(temp)
        if(new_rate > rate and ''.join(str(e) for e in temp) not in data):
            rate = new_rate
            index = zero_index+by
            last_moved = "down"
    
    return index

# moving the puzzle 
def moving(arr, zero_index):
    has_move = True
    by = int(math.sqrt(len(arr)-1))
    mod_value = zero_index % by
    temp_arr = arr[:]
    index_to_swap = -1
    if(mod_value == 1): # can't go back
        index_to_swap = greedy(temp_arr, zero_index, by, back=False, front=True)
    elif(mod_value == 0): # can't go front
        index_to_swap = greedy(temp_arr, zero_index, by, back=True, front=False)
    else: ## in middle 
        index_to_swap = greedy(temp_arr, zero_index, by, back=True, front=True)

    if(index_to_swap != zero_index):
        last_move_index = index_to_swap
        swap(arr, zero_index, index_to_swap)
    else:
        has_move = False

    return has_move

# run the game
def run(test):
    print_arr(test)
    has_move = True
    while(check(test) != 100 and has_move):
        zero_index = test.index(0, 1)
        has_move = moving(test, zero_index)
      
        print_arr(test)
        
    return has_move


def generate_mixed_puzzle(size, moves):
    temp = arr[:]
    
    by = int(math.sqrt(len(temp)-1))
    size = len(temp)
    i = 0
    states = [temp[:]]
    
    prev_move = ""
    curr_move = ""

    while(i < moves):
        moved = False
        method = randrange(1,5)
        zero_index = temp.index(0,1)

        if(method == 1 and zero_index % by != 0 and prev_move != "back"): #front
            move_to_index = zero_index+1
            moved = True
            curr_move = "front"
        elif(method == 2 and zero_index % by != 1 and prev_move != "front"): #back
            move_to_index = zero_index-1
            moved = True
            curr_move = "back"
        elif(method == 3 and zero_index - by > 0 and prev_move != "down"): #up    
            move_to_index = zero_index-by
            moved = True
            curr_move = "up"
        elif(method == 4 and zero_index + by < size and prev_move != "up"): # go down
            move_to_index = zero_index+by
            moved = True
            curr_move = "down"
        
        if(moved):
            swap(temp, zero_index,move_to_index)
            i+=1
            states.append(temp[:])
            prev_move = curr_move

    return temp, states
            
def run_visual():
    input("press ENTER to generated mixed puzzle(25 moves): ")
    mixed, gen_states = generate_mixed_puzzle(10, 25)

    if(sys.argv[1] == "save"):
        outfile = open("gen_data.txt", "w")
        outfile.write(json.dumps(gen_states, indent= 2))
        outfile.close()
        print("generated data saved")

    print_arr(mixed, True)

    input("press ENTER to find a solution: ")
    if(run(mixed)):
        print(f"found solution with {len(data)-1} moves\n\n")
    else:
        print("no solution found! exiting...")
        exit()

    int_data = []

    for string in data:
        arr = [int(string[0:2])]
        for char in string[2:]:
            arr.append(int(char))

        int_data.append(arr)
  

    move = 0
    hold_time = 5/len(data)

    if(len(sys.argv) == 2):
        input("press ENTER to solve the puzzle: ")
        global raw_data
        for var in raw_data:
            print("\033[2J\033[H")
            print(f"moves: {move}\n")
            print_arr(var, printing=True)

            sleep(hold_time)
            move+=1
    

# print help manu
if(len(sys.argv) > 1 and (sys.argv[1] == "-h" or sys.argv[1] == "--help")):
    print('''Greedy \033[96mA\033[0m. E\033[96mI\033[0mght \n\trun script:
    \t\t[]: run 100 trials with stats
    \t\t[run]: run a step by step visual solving
    \t\t[save]: visual + save states
    \t\t[run|save noshow]: run without showing visual\n\n
    ->->-|Developed by: 120TH-Grammer|-<-<-\n''')

elif(len(sys.argv) > 1): # run one puzzle in visual mode

    run_visual()
    if(sys.argv[1] == "save"):
        outfile = open("data.txt", "w")
        outfile.write(json.dumps(raw_data, indent= 2))
        outfile.close()
        print("states data saved")

else: # run 100 trials
    found = 0
    moves = 0
    print("running...")
    for i in range(0,100):
        mixed_data, states = generate_mixed_puzzle(10, 200)
        if(run(mixed_data)):
            found+=1

        moves += len(data)
        data = []

        #print(f"{i+1:.1f}%\r", end = "", flush=True)
        print(f"\033[7m{' '*(i//2)}\033[0m", end=f" {i+1:>{55-(i//2)}.1f}%\r",flush=True)

    print(f"{found}% solved, avg. moves: {moves/found:.1f}{' '*29}")

# run 25 trails
# for ((i=1;i<=25;i++)) do echo "test #$i"; python main.py;echo ""; done;